
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_PatientUnitSelection : BaseTest 
	{		
		
		private DataTable _dtBloodUnit;
		private DataTable _dtBloodUnitStatus;
		private DataTable _dtOrderedComponent;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//First let's create some test data
				this.UpdateExpirationDates();

				//****Get BloodUnit information
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM vw_BloodShipAllCurrent WHERE ProductTypeCode = 'E001' AND UnitStatusCode IN ('A','C','S') AND QuarantineIndicator = 0 AND UnitExpirationDate > GetUtcDate() AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				//*****Get BloodUnitStatus information
				this._dtBloodUnitStatus = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitStatus WHERE BloodUnitGuid = '" + this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid].ToString() + "'", true);

				//*****Get OrderedComponent information
				this._dtOrderedComponent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedComponent WHERE PatientSpecimenGuid IS NULL AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}
		}


		[Test]
		public void GetCompatibleWholeBloodUnits_Pass()
		{
			string bloodTypeCode = this._dtBloodUnit.Rows[0][TABLES.BloodUnitMedia.BloodTypeCode].ToString();
			string rhFactorCode = this._dtBloodUnit.Rows[0][TABLES.BloodUnitMedia.RhFactorCode].ToString();
			System.Guid patientGuid = System.Guid.NewGuid();		//PatientGuid is not that important
			string divisionCode = UnitTestConfig.TestDivisionCode;

			DataTable dtTest = DAL.PatientUnitSelection.GetCompatibleWholeBloodUnits(bloodTypeCode, rhFactorCode, patientGuid, divisionCode);

			Assert.AreEqual(47, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetCompatibleWholeBloodUnits_Fail()
		{
			string rhFactorCode = string.Empty;
			System.Guid patientGuid = System.Guid.NewGuid();
			string divisionCode = string.Empty;

			DAL.PatientUnitSelection.GetCompatibleWholeBloodUnits(null, rhFactorCode, patientGuid, divisionCode);
		}

		
		[Test]
		public void GetCompatiblePlateletBloodUnits_Pass()
		{
			DataTable dtTest = DAL.PatientUnitSelection.GetCompatiblePlateletBloodUnits(UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(47, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetCompatiblePlateletBloodUnits_Fail()
		{
			DataTable dtTest = DAL.PatientUnitSelection.GetCompatiblePlateletBloodUnits(string.Empty);
			//Assertion.AreEqual(xxxxxx, true, dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetCompatibleOtherBloodUnits_Pass()
		{
			DataTable dtTest = DAL.PatientUnitSelection.GetCompatibleOtherBloodUnits(UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(47, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetCompatibleOtherBloodUnits_Fail()
		{
			DataTable dtTest = DAL.PatientUnitSelection.GetCompatibleOtherBloodUnits(string.Empty);
		}

		[Test]
		public void GetCompatibleNonWholeBloodNonPlasmaUnits_Pass()
		{
			string bloodTypeCode = this._dtBloodUnit.Rows[0][TABLES.BloodUnitMedia.BloodTypeCode].ToString();
			string rhFactorCode = this._dtBloodUnit.Rows[0][TABLES.BloodUnitMedia.RhFactorCode].ToString();
			string divisionCode = UnitTestConfig.TestDivisionCode;

			DataTable dtTest = DAL.PatientUnitSelection.GetCompatibleNonWholeBloodNonPlasmaUnits(bloodTypeCode, rhFactorCode, divisionCode);

			Assert.AreEqual(46, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);			

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);
		}

		[Test]
		public void GetCompatibleNonWholeBloodNonPlasmaUnits_Fail()
		{
			//Check BloodType parameter
			try
			{
				DAL.PatientUnitSelection.GetCompatibleNonWholeBloodNonPlasmaUnits(null, "P", this.TestDivisionCode);
				Assert.Fail("Failed null BloodType condition");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Null BloodType condition");
			}

			//Check Rh parameter
			try
			{
				DAL.PatientUnitSelection.GetCompatibleNonWholeBloodNonPlasmaUnits("A", null, this.TestDivisionCode);
				Assert.Fail("Failed null rh condition");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Null rh condition");
			}

			//Check Division parameter
			try
			{
				DAL.PatientUnitSelection.GetCompatibleNonWholeBloodNonPlasmaUnits("A","P", null);
				Assert.Fail("Failed null division condition");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Null division condition");
			}


		}
		

		[Test]
		public void GetCompatibleFFPUnits_Pass()
		{
			//Check ABO - A
			DataTable dtTest = DAL.PatientUnitSelection.GetCompatibleFFPUnits("A", this.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count >= 0, "A-Rows.Count");

			//Check ABO - AB
			dtTest = DAL.PatientUnitSelection.GetCompatibleFFPUnits("AB", this.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count >= 0, "AB-Rows.Count");

			//Check ABO - B
			dtTest = DAL.PatientUnitSelection.GetCompatibleFFPUnits("B", this.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count >= 0, "B-Rows.Count");

			//Check ABO - O
			dtTest = DAL.PatientUnitSelection.GetCompatibleFFPUnits("O", this.TestDivisionCode);
			Assert.IsTrue(dtTest.Rows.Count >= 0, "O-Rows.Count");

			Assert.AreEqual(49, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);

			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);
		}

		[Test]
		public void GetCompatibleFFPUnits_Fail()
		{
			//BloodTypeCode - 
			try
			{
				DAL.PatientUnitSelection.GetCompatibleFFPUnits(null, this.TestDivisionCode);
				Assert.Fail("ArgumentException expected - Null BloodTypeCode");	
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "ArgumentException - Null BloodTypeCode");	
			}

			//DivisionCode - 
			try
			{
				DAL.PatientUnitSelection.GetCompatibleFFPUnits("A", null);
				Assert.Fail("ArgumentException expected - Null DivisionCode");	
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "ArgumentException - Null DivisionCode");	
			}

		}

		[Test]
		public void GetCompatibleCryoUnits_Pass()
		{
			string bloodTypeCode = this._dtBloodUnit.Rows[0][TABLES.BloodUnitMedia.BloodTypeCode].ToString();
			string divisionCode = UnitTestConfig.TestDivisionCode;

			DataTable dtTest = DAL.PatientUnitSelection.GetCompatibleCryoUnits(bloodTypeCode, divisionCode);

			Assert.AreEqual(49, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);

			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitContainerLotNumber), TABLES.BloodUnit.UnitContainerLotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);
		}

		[Test]
		public void GetCompatibleCryoUnits_Fail()
		{
			//BloodTypeCode - 
			try
			{
				DAL.PatientUnitSelection.GetCompatibleCryoUnits(null, this.TestDivisionCode);
				Assert.Fail("ArgumentException expected - Null BloodTypeCode");	
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "ArgumentException - Null BloodTypeCode");	
			}

			//DivisionCode - 
			try
			{
				DAL.PatientUnitSelection.GetCompatibleCryoUnits("A", null);
				Assert.Fail("ArgumentException expected - Null DivisionCode");	
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "ArgumentException - Null DivisionCode");	
			}

		}

		[Test]
		public void SaveUnits_Pass()
		{
			this.RefreshData = true;

			System.Guid orderedUnitGuid = System.Guid.NewGuid();
			System.Guid bloodGuid = (System.Guid)this._dtBloodUnitStatus.Rows[0][TABLES.BloodUnitStatus.BloodUnitGuid];
			System.Guid componentGuid = (System.Guid)this._dtOrderedComponent.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid];
			byte[] statusRowVersion = (byte[])this._dtBloodUnitStatus.Rows[0][TABLES.BloodUnitStatus.RowVersion];
			byte[] componentRowVersion = (byte[])this._dtOrderedComponent.Rows[0][TABLES.OrderedComponent.RowVersion];

			DataTable dtOrderedUnit = SprocHelper.GetInsertOrderedUnitSprocTable(orderedUnitGuid, System.Guid.Empty, bloodGuid);
			DataTable dtOrderedUnitComment = SprocHelper.GetInsertOrderedUnitCommentSprocTable(orderedUnitGuid);
			DataTable dtOrderedComponent = SprocHelper.GetUpdateOrderedComponentStatusSprocTable(componentGuid, componentRowVersion);
			DataTable dtExceptions = DAL.ExceptionReport.GetExceptionReportUnitSelection(bloodGuid).Tables[0].Copy();

			System.Guid [] patientGuids = new Guid[1];
			patientGuids[0] = System.Guid.NewGuid();

			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.CrossmatchUnitElectronic,  patientGuids, Common.WorkloadTransactionType.Patient, false);

			dtWorkloadEvents = Common.Utility.AppendLastUpdateInformation(dtWorkloadEvents, Common.UpdateFunction.UnitTests);

			bool retValue = DAL.PatientUnitSelection.SaveUnits(dtOrderedUnit, dtOrderedUnitComment, dtOrderedComponent, Common.UpdateFunction.UnitTests, dtExceptions, dtWorkloadEvents,null);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void SaveUnits_Fail()
		{
			System.Guid orderedUnitGuid = System.Guid.NewGuid();
			System.Guid bloodGuid = (System.Guid)this._dtBloodUnitStatus.Rows[0][TABLES.BloodUnitStatus.BloodUnitGuid];
			System.Guid componentGuid = (System.Guid)this._dtOrderedComponent.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid];
			byte[] statusRowVersion = new byte[8];
			byte[] componentRowVersion = new byte[8];

			DataTable dtOrderedUnit = SprocHelper.GetInsertOrderedUnitSprocTable(orderedUnitGuid, System.Guid.Empty, bloodGuid);
			DataTable dtOrderedUnitComment = SprocHelper.GetInsertOrderedUnitCommentSprocTable(orderedUnitGuid);
			DataTable dtOrderedComponent = SprocHelper.GetUpdateOrderedComponentStatusSprocTable(componentGuid, componentRowVersion);
			DataTable dtExceptions = null;
			System.Guid [] patientGuids = new Guid[1];
			patientGuids[0] = System.Guid.NewGuid();

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.CrossmatchUnitElectronic);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.CrossmatchUnitElectronic,  patientGuids, Common.WorkloadTransactionType.Patient, false);
			DAL.PatientUnitSelection.SaveUnits(dtOrderedUnit, dtOrderedUnitComment, dtOrderedComponent, Common.UpdateFunction.UnitTests, dtExceptions, dtWorkloadEvents,null);
		}


		/// <summary>
		/// Updates BloodUnitMedia so that we have some test data to work with
		/// </summary>
		private void UpdateExpirationDates()
		{
			string expirationDate = System.DateTime.Now.AddDays(7).ToString();

			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT BloodUnitGuid FROM vw_BloodShipAllCurrent WHERE UnitExpirationDate > getutcdate() AND ProductTypeCode = 'E001' AND UnitStatusCode IN ('A','C','S') AND QuarantineIndicator = 0 AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");

			if (dtTest.Rows.Count < 4)
			{
				UnitTestUtil.RunSQL("UPDATE BloodUnitMedia SET UnitExpirationDate = '" + expirationDate + "' WHERE BloodUnitGuid IN (SELECT TOP 3 BloodUnitGuid FROM vw_BloodShipAllCurrent WHERE DivisionCode = '" + this.TestDivisionCode + "' AND ProductTypeCode = 'E001' AND UnitExpirationDate < GetUTCDate() AND UnitStatusCode IN ('A','C','S') AND QuarantineIndicator = 0)");
			}
		}
	}
}

#endif
















